<?php
/*--------------------------------------------------------------------------------------------------
    PropertyQuantity.php 2020-03-18
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\Properties\SellingUnitQuantitiy\Quantitiy\Entities;

use Gambio\Shop\ProductModifiers\Modifiers\Collections\ModifierIdentifierCollectionInterface;
use Gambio\Shop\Properties\Properties\ValueObjects\CombinationId;
use Gambio\Shop\Properties\SellingUnitQuantitiy\Quantitiy\Exceptions\ProductDoesntUsePropertyQuantityException;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\Interfaces\QuantityInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\SellingUnitId;

class CombinationQuantity extends AbstractPropertyQuantity
{
    
    /**
     * @var CombinationId
     */
    private $combinationId;
    /**
     * @var SellingUnitId
     */

    /**
     * PropertyQuantity constructor.
     *
     * @param float $quantity
     * @param string $measureUnit
     * @param CombinationId $combinationId
     * @param bool $stockCheck
     * @param bool $attributeStockCheck
     * @param int $productStockCheckType
     *
     * @param ModifierIdentifierCollectionInterface $collection
     * @throws ProductDoesntUsePropertyQuantityException
     */
    public function __construct(
        float $quantity,
        string $measureUnit,
        CombinationId $combinationId,
        bool $stockCheck,
        bool $attributeStockCheck,
        int $productStockCheckType,
        ModifierIdentifierCollectionInterface $collection
    ) {
        
        parent::__construct($quantity, $measureUnit, $stockCheck, $attributeStockCheck, $productStockCheckType, $collection);
        $this->combinationId = $combinationId;
    }
    

    /**
     * @return CombinationId
     */
    public function combinationId(): CombinationId
    {
        return $this->combinationId;
    }

}